/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_04;

import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class LocalNotes {

	private static final String PASSWORD = "geheim";
	
	public static void main(String argv[]) {
		Session session = null;
		Database db = null;
		try {
			NotesThread.sinitThread();
			//Login als lokaler default User, entsprechend der Eintragung in der notes.ini
			session = NotesFactory.createSession((String) null, (String) null, PASSWORD);
			db = session.getDatabase((String) null, "djbuch/djbuch.nsf");
			printInfo(db);
			printInfo(session);
		} catch (NotesException e) {
			e.printStackTrace(System.err);
		} finally {
			try {
				if (db != null) {db.recycle();}
				if (session != null) {session.recycle();} 
			} catch (NotesException e) {
				System.err.println("Fataler Fehler.");
			}
			NotesThread.stermThread();
		}
	}

	private static void printInfo(Database db) throws NotesException {
		if (!db.isOpen()) {
			db.open();
		}
		if (!db.isOpen()) {
			System.out.println("Database could not be opened.");
			return;
		}
		System.out.println(db.getFilePath());
		DocumentCollection dc = db.search("@isavailable (Form)");
		System.out.println("Es wurden " + dc.getCount()
				+ " Dokumente mit dem Feld \"Form\" gefunden.");
		System.out.println(db.getACL().getFirstEntry().getName() + " "
				+ db.getACL().getNextEntry().getName());
	}

	private static void printInfo(Session s) throws NotesException {
		System.out.println("SessionClass\t= " + s.getClass().getName());
		System.out.println("Platform\t\t= " + s.getPlatform());
		System.out.println("Version\t\t\t= " + s.getNotesVersion());
		System.out.println("User\t\t\t= " + s.getUserName());
		System.out.println("Servername\t\t= <<" + s.getServerName() + ">>\n");
	}
}